//+------------------------------------------------------------------+
//|                                                CreateProject.mq5 |
//|                                 Copyright 2024-2026, Yuriy Bykov |
//|                            https://www.mql5.com/ru/users/antekov |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024-2026, Yuriy Bykov"
#property link      "https://www.mql5.com/ru/articles/19684"
#property description "Советник создаёт проект с этапами, работами и задачами оптимизации."
#property description "Стратегия: SimpleCandles"
#property description "Символы: GBPUSD, EURUSD, EURGBP"
#property description "Таймфреймы: M3,M5,M12"
#property description "Промежуток: 2025-01-01 - 2025-10-01"

#property version "1.00"

// 1. Определяем константу - признак наличия входных параметров
#define __INPUT_PARAMS__

// 2. Определяем константу - признак наличия функции шаблона параметров первого этапа
#define __PARAMS_TEMPLATE1__

// 3. Определяем константу - признак наличия функции шаблона параметров второго этапа
// #define __PARAMS_TEMPLATE2__

// 4. Определяем константу - признак наличия функции шаблона параметров третьего этапа
// #define __PARAMS_TEMPLATE3__

// 5. Подключаем шаблон советника создания проекта
#include "../../Adwizard/Experts/CreateProject.mqh"

//+------------------------------------------------------------------+
//| Входные параметры                                                |
//+------------------------------------------------------------------+
sinput group "::: База данных"
sinput string fileName_  = "article.19684.db.sqlite"; // - Файл базы данных оптимизации

sinput group "::: Параметры проекта - Основные"
sinput string  projectName_ = "SimpleCandles";        // - Название
sinput string  projectVersion_ = "1.01";              // - Версия
sinput string  symbols_ = "GBPUSD,EURUSD,EURGBP";     // - Символы
sinput string  timeframes_ = "M3,M5,M12";             // - Таймфреймы
//sinput ENUM_OPT_STAGE_ORDER
//   stageOrder_ = OPT_STAGE_ORDER_SEQUENTAL;         // - Последовательность этапов

sinput group "::: Параметры проекта - Интервал оптимизации"
sinput datetime fromDate_ = D'2025-01-01';            // - Дата начала
sinput datetime toDate_ = D'2025-10-01';              // - Дата окончания

sinput group "::: Параметры проекта - Счёт"
sinput string   mainSymbol_ = "GBPUSD";               // - Основной символ
sinput int      deposit_ = 100000;                    // - Начальный депозит

sinput group "::: Этап 1. Поиск"
sinput string   stage1ExpertName_ = "Stage1.ex5";     // - Советник этапа
sinput string   stage1Criterions_ = "6,6,6,6,6,6";    // - Критерии оптимизации для задач
sinput long     stage1MaxDuration_ = 120;              // - Макс. продолж. задач (с)

sinput group "::: Этап 2. Группировка"
sinput string   stage2ExpertName_ = "Stage2.ex5";     // - Советник этапа
sinput string   stage2Criterion_  = "6";              // - Критерий оптимизации для задач
sinput long     stage2MaxDuration_ = 300;             // - Макс. продолж. задач (с)
//sinput bool     stage2UseClusters_= false;          // - Использовать кластеризацию?
sinput double   stage2MinCustomOntester_ = 500;       // - Мин. значение норм. прибыли
sinput uint     stage2MinTrades_  = 20;               // - Мин. кол-во сделок
sinput double   stage2MinSharpeRatio_ = 0.7;          // - Мин. коэфф. Шарпа
sinput uint     stage2Count_      = 8;                // - Кол-во стратегий в группе (1 - 16)


sinput group "::: Этап 3. Итог"
sinput string   stage3ExpertName_ = "Stage3.ex5";      // - Советник этапа
sinput ulong    stage3Magic_      = 1968401;           // - Magic
sinput bool     stage3Tester_     = true;              // - Для тестера?


// Шаблон параметров оптимизации на первом этапе
string paramsTemplate1(COptimizationProject *p) {
   string params = StringFormat(
                      "symbol_=%s\n"
                      "period_=%d\n"
                      "; ===  Параметры сигнала к открытию\n"
                      "signalSeqLen_=4||2||1||8||Y\n"
                      "periodATR_=28||28||2||210||N\n"
                      "; ===  Параметры отложенных ордеров\n"
                      "stopLevel_=2.34||0.01||0.01||20.0||Y\n"
                      "takeLevel_=4.55||0.01||0.01||10.0||Y\n"
                      "; ===  Параметры управление капиталом\n"
                      "maxCountOfOrders_=20||1||1||30||N\n"
                      "maxSpread_=100||10||1||100||N\n",
                      p.m_symbol, p.StringToTimeframe(p.m_timeframe));
   return params;
}
//+------------------------------------------------------------------+
